/*
 * Decompiled with CFR 0.152.
 */
package com.bghddevelopment.bungeeannounce.listeners;

import com.bghddevelopment.bungeeannounce.Fate;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class IncomingMessageListener
implements Listener {
    public IncomingMessageListener() {
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)Fate.getInstance(), (Listener)this);
    }

    @EventHandler
    public void onBroadcast(PluginMessageEvent event) {
        try {
            String tag = event.getTag();
            if (tag.equalsIgnoreCase(Fate.getInstance().getIncomingBroadcastChannel())) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(event.getData()));
                String channel = dataInputStream.readUTF();
                if (!channel.equalsIgnoreCase("BroadcastChannel")) {
                    return;
                }
                ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(dataInputStream.readUTF());
                String message = dataInputStream.readUTF();
                ProxyServer.getInstance().getPlayers().forEach(online -> {
                    if (online == proxiedPlayer) {
                        proxiedPlayer.sendMessage((BaseComponent)new TextComponent("\u00a7aYou've broadcasted message: " + message));
                    } else {
                        online.sendMessage((BaseComponent)new TextComponent(message));
                    }
                });
                return;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @EventHandler
    public void onAnnouncement(PluginMessageEvent event) {
        try {
            String tag = event.getTag();
            if (tag.equalsIgnoreCase(Fate.getInstance().getIncomingAnnouncementChannel())) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(event.getData()));
                String channel = dataInputStream.readUTF();
                if (!channel.equalsIgnoreCase("AnnounceChannel")) {
                    return;
                }
                ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(dataInputStream.readUTF());
                String message = dataInputStream.readUTF();
                ProxyServer.getInstance().getPlayers().forEach(online -> {
                    if (online == proxiedPlayer) {
                        proxiedPlayer.sendMessage((BaseComponent)new TextComponent("\u00a7aYou've announced message: " + message));
                    } else {
                        TextComponent textComponent = new TextComponent(message);
                        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/server " + proxiedPlayer.getServer().getInfo().getName()));
                        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to join " + proxiedPlayer.getServer().getInfo().getName()).color(ChatColor.GREEN).create()));
                        online.sendMessage((BaseComponent)textComponent);
                    }
                });
                return;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

