/*
 * Decompiled with CFR 0.152.
 */
package com.broustudio.MizuAPI;

import com.broustudio.MizuAPI.database.PlayerDataManager;
import com.broustudio.MizuAPI.mongodb.MongoCollections;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MizuAPI
extends JavaPlugin {
    public static MizuAPI instance;
    public static PlayerDataManager playerDataManager;
    public static MongoCollections mongoCollections;
    public static MongoDatabase mongoDatabase;
    public static File main;
    public static FileConfiguration mainConfig;
    public static File rank;
    public static FileConfiguration rankConfig;
    public static File tag;
    public static FileConfiguration tagConfig;

    public void onEnable() {
        instance = this;
        this.registerConfigs();
        this.mongoSetup();
        playerDataManager = new PlayerDataManager();
        mongoCollections = new MongoCollections();
        Bukkit.getConsoleSender().sendMessage("");
        Bukkit.getConsoleSender().sendMessage("");
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[MizuAPI] Successfully loaded API.");
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[MizuAPI]" + ChatColor.RED + " NOTE: API always return data from Database");
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[MizuAPI]" + ChatColor.RED + " We recommend caching the data on your plugin side.");
        Bukkit.getConsoleSender().sendMessage("");
        Bukkit.getConsoleSender().sendMessage("");
    }

    public void registerConfigs() {
        main = new File("plugins/Mizu/config.yml");
        mainConfig = YamlConfiguration.loadConfiguration((File)main);
        rank = new File("plugins/Mizu/permissions.yml");
        rankConfig = YamlConfiguration.loadConfiguration((File)rank);
        tag = new File("plugins/Mizu/tags.yml");
        tagConfig = YamlConfiguration.loadConfiguration((File)tag);
    }

    public void mongoSetup() {
        String uri = mainConfig.getString("Database.MONGODB.connection-string");
        String dbname = mainConfig.getString("Database.MONGODB.database-name");
        MongoClientURI mongoURI = new MongoClientURI(uri);
        MongoClient mongoClient = new MongoClient(mongoURI);
        mongoDatabase = mongoClient.getDatabase(dbname);
        Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
        mongoLogger.setLevel(Level.SEVERE);
    }

    public static MizuAPI getInstance() {
        return instance;
    }

    public static PlayerDataManager getAPI() {
        return playerDataManager;
    }

    public static FileConfiguration getRankConfig() {
        return rankConfig;
    }

    public static MongoDatabase getMongoDatabase() {
        return mongoDatabase;
    }

    public static MongoCollections getMongoCollections() {
        return mongoCollections;
    }
}

