/*
 * Decompiled with CFR 0.152.
 */
package xyz.haoshoku.nick.api;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import xyz.haoshoku.nick.NickPlugin;
import xyz.haoshoku.nick.api.API;
import xyz.haoshoku.nick.user.NickHandler;
import xyz.haoshoku.nick.user.NickUser;

public class NickAPI
implements API {
    @Override
    public void nick(Player player, String toNick) {
        NickPlugin.getPlugin().getStarter().getManager().nick(player, toNick);
    }

    @Override
    public void nick(Player player, String toNick, String toUUIDByPlayerName) {
        NickPlugin.getPlugin().getStarter().getManager().nick(player, toNick, toUUIDByPlayerName);
    }

    @Override
    public void nick(Player player, String toNick, UUID toUUID) {
        NickPlugin.getPlugin().getStarter().getManager().nick(player, toNick, toUUID);
    }

    @Override
    public List<UUID> getBypassList(Player player) {
        return NickHandler.getUser(player).getBypassList();
    }

    @Override
    public void addBypass(Player bypassPlayer, Player nickedPlayer) {
        if (nickedPlayer != null && nickedPlayer.isOnline()) {
            this.addBypass(bypassPlayer, nickedPlayer.getUniqueId());
        }
    }

    @Override
    public void removeBypass(Player bypassPlayer, Player nickedPlayer) {
        if (nickedPlayer != null && nickedPlayer.isOnline()) {
            this.removeBypass(bypassPlayer, nickedPlayer.getUniqueId());
        }
    }

    @Override
    public void addBypass(Player bypassPlayer, UUID nickedPlayerOriginalUUID) {
        NickUser nickUser = NickHandler.getUser(bypassPlayer);
        nickUser.getBypassList().add(nickedPlayerOriginalUUID);
    }

    @Override
    public void removeBypass(Player bypassPlayer, UUID nickedPlayerOriginalUUID) {
        NickUser nickUser = NickHandler.getUser(bypassPlayer);
        nickUser.getBypassList().remove(nickedPlayerOriginalUUID);
    }

    @Override
    public void clearBypass(Player bypassPlayer) {
        NickUser nickUser = NickHandler.getUser(bypassPlayer);
        nickUser.getBypassList().clear();
    }

    @Override
    public void unnick(Player player) {
        NickUser nickUser = NickHandler.getUser(player);
        nickUser.setNickedPlayer(null);
        nickUser.setNickedUUID(null);
        NickPlugin.getPlugin().getStarter().getManager().unnick(player);
        nickUser.setNickedGameProfile(null);
    }

    @Override
    public boolean isNicked(Player player) {
        return NickHandler.getUser(player).getNickedPlayer() != null;
    }

    @Override
    public void setSkin(Player player, String toSkin) {
        NickPlugin.getPlugin().getStarter().getManager().setSkin(player, toSkin);
    }

    @Override
    public void setSkin(Player player, String value, String signature) {
        NickPlugin.getPlugin().getStarter().getManager().setSkin(player, value, signature);
    }

    @Override
    public void refreshPlayer(Player player) {
        NickPlugin.getPlugin().getStarter().getManager().refreshPlayer(player);
    }

    @Override
    public void refreshPlayer(Player player, int ticks) {
        NickPlugin.getPlugin().getStarter().getManager().refreshPlayer(player, ticks);
    }

    @Override
    public Map<UUID, String> getNickedPlayers() {
        return NickPlugin.getPlugin().getStarter().getManager().getNickedPlayers();
    }

    @Override
    public boolean nickExists(String name) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            NickUser nickUser = NickHandler.getUser(player);
            if (nickUser.getNickedPlayer() != null && name.equalsIgnoreCase(nickUser.getNickedPlayer())) {
                return true;
            }
            if (!name.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNickedName(Player player) {
        return NickHandler.getUser(player).getNickedPlayer();
    }

    @Override
    public Player getPlayerOfOriginalName(String originalName) {
        for (NickUser nickUser : NickHandler.getUsers()) {
            if (nickUser == null || !nickUser.getOriginalPlayerName().equalsIgnoreCase(originalName)) continue;
            return nickUser.getPlayer();
        }
        return null;
    }

    @Override
    public Player getPlayerOfNickedName(String nickedName) {
        return NickPlugin.getPlugin().getStarter().getManager().\ufe99(nickedName);
    }

    @Override
    public String getOriginalGameProfileName(Player player) {
        return NickPlugin.getPlugin().getStarter().getManager().getOriginalGameProfileName(player);
    }

    @Override
    public String getGameProfileName(Player player) {
        return NickPlugin.getPlugin().getStarter().getManager().getGameProfileName(player);
    }

    @Override
    public void setGameProfileName(Player player, String name) {
        NickPlugin.getPlugin().getStarter().getManager().setGameProfileName(player, name);
    }

    @Override
    public void resetGameProfileName(Player player) {
        NickPlugin.getPlugin().getStarter().getManager().resetGameProfileName(player);
    }

    @Override
    public void resetFakeUUID(Player player) {
        NickPlugin.getPlugin().getStarter().getManager().resetFakeUUID(player);
    }

    @Override
    public UUID getFakeUUID(Player player) {
        return NickHandler.getUser(player).getNickedUUID();
    }

    @Override
    public void setFakeUUID(Player player, UUID uuid) {
        NickPlugin.getPlugin().getStarter().getManager().\ufe99(player, uuid);
    }

    @Override
    public void setFakeUUID(Player player, String name) {
        NickPlugin.getPlugin().getStarter().getManager().\ufe98(player, name);
    }

    @Override
    public boolean isCurrentlyRefreshing(Player player) {
        NickUser nickUser = NickHandler.getUser(player);
        return nickUser.isFirstQueue() || nickUser.isSecondQueue() || nickUser.isThirdQueue() || nickUser.isForthQueue();
    }
}

