/*
 * Decompiled with CFR 0.152.
 */
package xyz.haoshoku.nick.user;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import xyz.haoshoku.nick.NickPlugin;
import xyz.haoshoku.nick.user.NickUser;

public class NickHandler {
    private static final Map<UUID, NickUser> NICK_USER_MAP = new HashMap<UUID, NickUser>();

    public static NickUser getUser(Player player) {
        return NickHandler.getUserByUUID(player.getUniqueId());
    }

    public static NickUser getUserByUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        if (!NICK_USER_MAP.containsKey(uuid)) {
            NICK_USER_MAP.put(uuid, new NickUser(uuid));
        }
        return NICK_USER_MAP.get(uuid);
    }

    public static NickUser[] getUsers() {
        NickUser[] nickUserArray = new NickUser[NICK_USER_MAP.size()];
        int n = 0;
        for (Map.Entry<UUID, NickUser> entry : NICK_USER_MAP.entrySet()) {
            nickUserArray[n] = entry.getValue();
            ++n;
        }
        return nickUserArray;
    }

    public static void deleteUser(Player player) {
        if (NICK_USER_MAP.containsKey(player.getUniqueId())) {
            NickPlugin.getPlugin().getAPI().unnick(player);
            NickPlugin.getPlugin().getStarter().getManager().resetGameProfileName(player);
            NICK_USER_MAP.remove(player.getUniqueId());
        }
    }

    public static void deleteUserByUUID(UUID uuid) {
        if (NICK_USER_MAP.containsKey(uuid)) {
            NICK_USER_MAP.remove(uuid);
        }
    }
}

